Emigration to America

Our paper of Thursday last contained a general view of some of the most popular publications on the subject of emigration, and we shall now endeavour briefly to make an estimate of the good and evil which is likely to befall those who embark in this hazardous adventure.

There is one important fact which we gather from all the accounts of America, whether written for the purpose of praise or censure, namely, that there is a great demand for labour, and that wages are high, and this effect is necessarily produced y the vast space of fertile and unoccupied territory which lies westward of the United States towards the Pacific Ocean. It is this vacant territory which is the true spring of this American community. Here is the grand outlet for the superflouous population both of the eastern states of America and of Europe. To cultivate this waste there is a constant demand for new labourers ; wages are, of course, high – the labourer lives in comfort, and, if he is industrious, he becomes in his turn a purchaser of land from the savings which he accumulates. If labour should become more plentiful, and wages should fall, this is the signal for new emigrations ; and thus, this constant demand for labour in the western districts regulates its general price throughout the United States. In these circumstrances it is clear that a labourer, provided he can reach this advantageous market for his labour, will unquestionably improve his condition. But herein lies the difficulty. A labourer has seldom the means of of subsistence so far beforehand as to enable him to undertake so long a journey ; and, if he enters upon the enterprise with insufficient means, he is liable to starve before he can transport himself to his ultimate destination, or he is forced to contract, for immediate subsistence, obligations little short of servitude, under the weight of which he is grievously oppressed. These, then form strong objections to emigrations in the case of those who are stinted to their means ; but where these objections can be surmounted, those who can transport their labour from the overstocked market of Europe to the understocked market of America, will unquestionably dispose of it to better advantage ; but if they have not the means, they may as furely fail in the attempt, and draw upon themselves aggravated misery and want. As to the consequences of emigration to this country, we hold them rather to be beneficial than otherwise, and we cannot easily account for the very absurd alarm which has been propagated on this subject. The evil in Europe is, that every country is overcrowded with labourers, who cannot find employment ; and is it not manifest, therefore, that the withdrawing of some of these will make more room for the labourers that remain – that the loss of those useless hands will rather be a relief to the body politic, and will diffuse greater soundness and vigour through all its parts? That these effects will follow from emigration in this or in any other country in Europe we cannot doubt – and that the labourer, if he can afford the expence of the journey, will receive higher wages in America than in this country, is equally clear.

There is another class of adventurers who may possibly improve their circumstances by emigration, although this is not so certain, namely, farmers with a moderate capital. An allotment of land may be purchased in the back parts of America at the Government price of two dollars per acre, and an emigrant who can afford to but and to cultivate 100 or 200 acres, and acts with proper judgement and skill, may undoubtedly, by a speculation of this sort, be sure of a subsistence, while, by the continued emigrations from the eastern states, the country being quickly settled all around him, his property is daily improving in value. But a want of judgement in the purchase, or a want of ability to cultivate the land after it is purchased, may involve him in irrecoverable distress and ruin ; and to avoid these hazards no little discrimination and prudence is necessary.

Such are some of the most striking advantages of emigration, and we shall now state some of its disadvantages. The first, and chief of these, is the difficulty of effecting a settlement, and of subsisting until the land which is purchased yields its first produce. The country is partly open ground, or prairie, as it is called, or it is covered with almost boundless forests. A settlement in the woods requires incredible labour to clear it – labour is dear, and not easily procured, and this herculean task naturally devolves on the head of the family, who is forced during the day to ply the axe in this laborious drudgery of felling trees, and afterwards to follow the chace for a meal to his family. Here he must frequently sleep out in the woods ; and his body, exhausted with his day's labour, is exposed to the cold dews of night ; under such unintermitted toil his health declines, and it is obvious that his family, deprived even for a single day of his exertions, must be reduced to the most deplorable straits. In many parts the country which is marked out for emigrants is extremely unhealthy, in particular the banks of all the navigable rivers, which afford the most eligible settlements both in point of fertility and situation, are exposed to the most fatal maladies. The same causes which produce fertility produce disease. The overflowing of the waters, from the autumnal and spring floods, fertilise the land in a most wonderful degree ; but the exhalations of these stagnant waters, under a burning sun, are as fatal to the health as the deposits which they leave are favourable to the soil. Hence the many minute directions which are given to all emigrants in regard to their health. In a letter contained in the Emigrant's Guide, we have the following advice to those who are descending the Ohio : " If the weather becomes warm, guard well against the smell of bilge water. But if you must descend in the spring, go early – avoid all delay, and remember you are fleeing for your lives. I have seen the havoc, and I believed it not till then." Again it is observed, " Let nothing tempt you to fish in warm weather, immediately on changing your climate. The effluvia of the shores is poison." To a European emigran the climate must be, of course, even more fatal ; and he either therefore lose his health, or he must be continually tormented with anxiously taking care of it, which makes it a question whether it is worth having on such terms. Such are the hardships through which, if he has strength to endure them, he at length emerges into ease and independence. These hardships, however, will no doubt be in a great measure avoided, or at least mitigated, if he has beforehand provided the means of subsistence until he can derive regular supplies from his own land. In this case he is less liable to be dislodged from his situation by the casualties to which all emigrants are necessarily exposed. – He is secured against the hardships of a first settlement, and is more certain of attaining the wished for object of ease and affluence – To a farmer, therefore, or a labourer, emigration presents a fair chance of a permanent settlement, provided it is gone about with ordinary caution, and the necessary degree of energy be exerted to insure success. But it is a gross delusion to imagine that an elysium is to be found in the United States, or that mankind exist there on any more favourable terms than in this country, and those who set out on any such visionary schemes are sure to meet with a woeful disappointment. With regard to other classes of society, it does not appear that they will improve their condition by emigration to America ; there is no demand for clerks or professional men of any sort, and no merchant has any thing to expect by removing his capital to the United States. In the back settlements there is a demand for schoolmasters to teach the ordinary branches of education, and several emigrants of this class have met with good encouragement.

In regard to the essential article of comfort, it is apparent, from all the best information on the subject, that a person long resident in this country would change for the worse by an emigration to the United States. He would, in the first place, suffer extremely from the climate, from the extreme cold of winter and the raging heat of summer, the thermometer frequently standing at 98 degrees in the share, with a clear sky and broiling sun, and very little abatement of this exsessive heat being experienced through the night. His frame, accustomed to the more temperate, though unsettled climate of this country, runs the risk of being debilitated by the change, and at all events he must suffer extremely in his enjoyments and in his spirit from this cause. Nor, we should imagine, would the manners of the people in the back parts be found very agreeable or polished. It is admitted on all hands, both by those who are favourable and those who are unfavourable to the Americans, that if there is not, as in Europe, gross ignorance and debasement on the one hand, neither is there on the other any thing much exalted above the ordinary level. But the inferences which arise from this established fact are strongly in favour of Europe. The grossness of vice and ignorance carries a sure antidote to its corruptions in the disgust which it excites : such examples are not so potent to debase, as examples of a different sort are to purify and exalt. There is little risk that society will be contaminated by what is low and debased ; but on the other hand, there is a certainty that what is exalted and illustrious in literature, science, taste, accomplishments, or fashion, will exercise a powerful influence on the general state of manners. We naturally copy what we admire, and those great and shining examples constitute a standard to which the whole system of life and manners has a tacit reference. In the United States they have no such models – they do not aim at so high a standard, and taste and manners are therefore necessarily at a lower ebb than in Europe – Hence all accounts agree in reprobating the extreme filthy habits which universally prevail ; and Cobbett, who will be suspected of too great partiality to this country, draws a contrast between the inhabitants of Hampshire and those of the United States, in which he places this vice of the American manners in strong colours ; and he adds, as his reason for this, that they have no gentlemen's seats, with the fine improvements of pleasure grounds, &c. dispersed through the country, as models of taste and neatness for the inferior classes, and it is to the same principles that we may trace other defects in their manners, namely, that they have no proper models on which to form themselves. Hence, excepting in the principal cities, we may safely conclude, from all the information we have received on the subject, that society has not reach the same degree of refinement as in this country.

An emigrant accustomed to live in Britain would also feel the disavantages of American society strong in this, that here, in so closely peopled a community, surrounded with all sorts of refinements, life is assisted by such a variety of helps, that it glides down the smooth stream of comfort and convenience, without ever meeting with a single interruption. It is astonishing to what a pitch of improvement a society is brough, abounding in wealth and in all the mechanical arts, and where the ingenuity of thousands is incessantly on the rack to set on foot new devices for the common good. We are not duly sensible of the advantages of this, because, like other advantages, they are familiar to us by long habit, and we begin to imagine that they are inherent in the natural constitution of things. But when we are suddenly transplanted into a new community, abounding indeed in subsistence, but deficient in all comforts – where only the coarsest mechanic arts are practised – where the inhabitants are so widely dispersed, that their common exertions cannot be made available for the common good, we find life interrupted at every turn. In our former society, if we had not the previous secret of transmuting all things into gold, we had at least the power of transmuting gold into every thing else. But here the power of money is limited. We must indeed pay for services, but we must also beg for them ; and thus we go on fretting and tormenting ourselves under petty incommodities, which in this country would be remedied as soon as they were felt. It is inconceivable how much inconvenience and discomfort and real unhappiness may spring from this cause. In this country, by long habit and pracrice and continual improvement, every thing has fallen into its right place – each individual has a separate task assigned him in the joint task of labouring for the general benefit – and the industry of all, however variously directed, tends to one common end. There is a perfect unity of effort. We all labour in common – we combine our efforts that they may yield the largest possible produce, and this produce is accurately shared among the various members of the community, each receiving the share to which his labour entitles him. Such is substantially the process by which commerce diffuses the benefits of industry over every civilized community. – Money is the instrument by which this division is effected. Every one who labours has the value of his labour ascertained in money, which is a draft upon the common stock for whatever quantity of necessaries and luxuries he is entitled to ; and all these complicated operations are executed with a regularity almost mechanical. But in a community newly forming there is a want of unity and combination – all the members labour indeed, but no one has his proper part assigned him – there is a jostling and an interference with each other – and when they come to divide, some have too much, and some too little, of certain articles – the stock is ill assorted, and money will not execute its functions. Hence disorder arises, and inconvience and awkward wants, and an individual suddenly removed into this region of discomfort from the happier climate of a highly improved community, must be annoyed with feeling in the highest degree gloomy and disagreeable. He must have the same sensation as a person who quits an elegant mansion, fitted up with every comfort and convenience, for one of inferior quality and coarsely finished, where he is exposed to a thousand annoyances every minute. It is observed by Dr Johnson, that the evil of life does not consist in any sudden and overwhelming crash of misery, but in a series of petty discomforts amd mischiefs continually preying upon the temper. The truth of this maxim, those who emigrate from this country to the back woods of America, will have a good opportunity of verifying.

The prevalence of slavery in most of the States of the Union constitutes another capital defect in the structure of American society. These slaves form a degraded and oppressed class, and, in the tyranny exercised over them, they themselves are morally destroyed, while the corruption extends to the other orders of society, equally infecting the oppressed and the oppressor, and debasing the general character and habits of the people. It is vain to talk of liberty while stain of tyranny so deeply infects the domestic manners of a community. There can be no rational liberty unless we call that liberty which gives us the privilege of torturing and oppressing our fellow creatures. To give an idea of the consequences of this dreadful evil of slavery, we may state, that it is a practice in Kentucky to commit delinquent slaves into the hands of the public executioner, by whom they are unmercifully flogged at the markey cross of the different towns, the streets being filled with their pietous cries. What can we think of the people where such spectacles are for a moment tolerated. This is so utterly revolting to every just and enlightened feeling, that to a European it would form a strong objection to his permanent residence in that country. In all the northern states, and in some of the new states, particularly that of the Ohio, slavery is indeed abolished. But in several others the black form a large proportion of the population, and they are not decreasing. We know indeed that this evil is admitted in its full extent by all the American statesmen, that they lament it, but do not well see what measures can be adopted to check it. The importation of new slaves is indeed prohibited, but the increase of those already in the country is the great grievance, against which it is difficult to devise a remedy, and the cruel and oppressive treatment which slaves will always meet with wherever they exist, must tend to degrade the habits and moral feelings of the community at large. To such, therefore, as are accustomed to European society, where no such strain of tyranny infects the domestic manners, an exchange into a community where his feelings may be revolted by spectacles of gross cruelty cannot be regarded as very desirable. If more imperious considerations permit, they have certainly a greater chance for happiness by remaining where the rights of nature are respected, than by removing to a society where every principle of humanity is trampled upon.

